/* Take 4-bit BCD in, output 7 bits of segment (a-g) */
module bcd_to_7seg(bcd, segments);
   input [3:0] bcd;
   output [6:0] segments;
   wire [6:0] segments;

   assign segments = (bcd == 4'h0) ? 7'b1111110 :
        (bcd == 4'h1) ? 7'b0110000 :
        (bcd == 4'h2) ? 7'b1101101 :
        (bcd == 4'h3) ? 7'b1111001 :
        (bcd == 4'h4) ? 7'b0110011 :
        (bcd == 4'h5) ? 7'b1011011 :
        (bcd == 4'h6) ? 7'b1011111 :
        (bcd == 4'h7) ? 7'b1110000 :
        (bcd == 4'h8) ? 7'b1111111 :
        (bcd == 4'h9) ? 7'b1111011 :
                     7'b0000000;

endmodule