/* A counter: counts 0 to 9, then wraps to 0 again. */
module counter(clk, reset, enable, count, carry_out);
   input clk;
   input reset;
   input enable;
   output [3:0] count;
   output carry_out;

   /* Define four flip flops -- a 4-bit register -- to hold the
      state in this state machine.  (In other words, the count value.)
    */
   reg [3:0] count;

   wire      carry_out = (count == 4'h9);

   always @ (posedge clk or posedge reset)
     begin
        if (reset)
          count <= 0;
        else
          if (enable)
            begin
               /* At a positive clock edge, iff enabled, latch what
                  the combinatorial logic has been calculating as
                  the new value:
                */
               if (count == 4'h9)
                 count <= 0; /* Wrap */
               else
                 count <= count + 1;
            end
     end
endmodule // counter
