/* Generate reset pulse.  This is a little hacky but avoids relying on
 * an external reset pin, whilst allowing us an internal RESET to get
 * our state machines in order.
 * 
 * Directly instantiate some Xilinx flipflops -- these are guaranteed to be zero
 * on startup, and provide a pulse for a couple of clocks:
 */
module reset_gen(clk, reset);
   input clk;
   output reset;

   wire       rst_1, rst_2, rst_3;

   FD rstff_1 (.C(clk), .D(1'b1), .Q(rst_1));
   defparam rstff_1.INIT = 1'b0;
   FD rstff_2 (.C(clk), .D(rst_1), .Q(rst_2));
   defparam rstff_2.INIT = 1'b0;
   FD rstff_3 (.C(clk), .D(rst_2), .Q(rst_3));
   defparam rstff_3.INIT = 1'b0;
   INV rst_inv (.I(rst_3), .O(reset));

endmodule
