`timescale 1ns/1ns

module tb_toplevel();
   reg [3:0] bcd_count;
   wire [6:0] segs;

   bcd_to_7seg my_decoder(.bcd(bcd_count), .segments(segs));

   initial
   begin
      /* These lines log the signal changes to a file so we can look in GTKwave */
      $dumpfile("7seg.vcd");
      $dumpvars(0, tb_toplevel);

      for (bcd_count = 0; bcd_count < 4'd10; bcd_count = bcd_count + 1)
	begin
           #1;
           $display($time, " Segment outputs %b for input %x\n", segs, bcd_count);
	end
      $finish;
   end
endmodule