`timescale 1ns/1ns

`define CLK_PERIOD 200

module tb_toplevel();
   reg clk = 0;
   reg reset = 0;
   reg enable = 0;

   always #(`CLK_PERIOD/2) clk = !clk;

   wire [3:0] bcd_count;
   wire       co;

   counter my_counter(.clk(clk), .reset(reset), .count(bcd_count), 
		      .enable(enable), .carry_out(co));

   initial
   begin
      /* These lines log the signal changes to a file so we can look in GTKwave */
      $dumpfile("counter.vcd");
      $dumpvars(0, tb_toplevel);

      /* Provide a reset pulse */
      reset <= 1;
      #50;
      reset <= 0;

      $display("Initial value is %x\n", bcd_count);

      /* Now do 5 clocks, but keep enable low */
      #(`CLK_PERIOD * 5);
      $display("Counter not enabled, value %x\n", bcd_count);

      /* Now enable, do another 5 */
      enable <= 1;

      #(`CLK_PERIOD * 5);
      $display("Counter enabled, value %x\n", bcd_count);

      /* Do a few more, let it wrap */
      #(`CLK_PERIOD * 7);
      $display("Counter enabled, value %x\n", bcd_count);

      $finish;
   end
endmodule