`timescale 1ns/1ns

module glbl();
   reg GSR = 0;
endmodule

`define CLK_PERIOD 200
module tb_toplevel();
   reg clk = 0;

   reg button = 0;
   wire [3:0] led_enables;
   wire [7:0] segs;

   /* Generate a free-running system clock -- 
      pretending to be the oscillator on board */
   always #(`CLK_PERIOD/2) clk = !clk;

   top_level counterthingy(.clk0(clk), .button0(button),
			   .digit_en(led_enables), .segments(segs));

   initial
   begin
      /* These lines log the signal changes to a file so we can look in GTKwave */
      $dumpfile("toplevel.vcd");
      $dumpvars(0, tb_toplevel);

      /* Do a few clocks to let the design reset itself */
      #(`CLK_PERIOD * 100);

      /* Pretend to press the button (need to 'hold' it down for a while!) */
      button <= 1;
      #(`CLK_PERIOD * 275);
      button <= 0;

      #(`CLK_PERIOD * 10000);

      button <= 1;
      #(`CLK_PERIOD * 275);
      button <= 0;

      /* Clock a long while to see the LED multiplexers in action */
      #(`CLK_PERIOD * 300000); 
      
      $finish;
   end
endmodule